<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:47 PM
 */

namespace Visionware\DataManager;
final class HistorySchemaManager extends SchemaManager {
//    protected $valid_scopes = ['erpfeed'];
//    protected $statements = [
//        'schema' => [
//            'create_schema' => ['create' => 'create_schema', 'drop' => 'drop_schema'],
//            'use_schema'    => 'use_schema',
//        ],
//        'table'  => [
//            'records_table'     => ['create' => 'create_table', 'drop' => 'drop_table'],
//            'files_table'       => ['create' => 'create_table', 'drop' => 'drop_table'],
//            'snapshots_table'   => ['create' => 'create_table', 'drop' => 'drop_table'],
//            'file_record_table' => ['create' => 'create_table', 'drop' => 'drop_table'],
//            'staging_table'     => ['create' => 'create_table', 'drop' => 'drop_table'],
//            'latest_view'       => [
//                'create' => '',
//                'drop'   => 'DROP VIEW IF EXISTS `%table%_latest`;',
//            ],
//        ],
//    ];

    protected function create_schema($name) {
        $this->sql[] = $this->grammar->create_schema($name);
        $this->sql[] = $this->grammar->use_schema($name);
    }

    protected function create_table($table) {
        $info = $this->new_definition['tables'][$table];
        if (!array_key_exists('imported_from', $info)) return;
//        if (!in_array($info['scope'], $this->valid_scopes)) return;
        $this->create_file_record_table($table);
        $this->create_files_table($table);
        $this->create_records_table($table, $info);
        $this->create_snapshots_table($table);
        $this->create_staging_table($table, $info);
        $this->create_latest_view($table);
    }

    protected function create_column($column, $table) {
        $info = $this->new_definition['tables'][$table];
        if (!array_key_exists('imported_from', $info)) return;

        $info = $this->lookup_column($this->new_definition, $column, $table);
        if (array_key_exists('foreign', $info)) return false;
        if (strcasecmp(substr($info['type'], 0, 7), 'varchar')) $info['type'] = 'varchar(32)';
        if (!$info) die("THIS CAN'T HAPPEN");
        $this->sql[] = $this->grammar->create_column($table . '_records', $this->grammar->column_definition($column, $info['type'], isset($info['nullable']) ? $info['nullable'] : false, isset($info['default']) ? $info['default'] : false));
        $this->sql[] = $this->grammar->create_column($table . '_staging', $this->grammar->column_definition($column, $info['type'], isset($info['nullable']) ? $info['nullable'] : false, isset($info['default']) ? $info['default'] : false));
    }

    protected function drop_column($column, $table) {
        $info = $this->new_definition['tables'][$table];
        if (!array_key_exists('imported_from', $info)) return;

        $this->sql[] = $this->grammar->drop_column($table . '_records', $column);
        $this->sql[] = $this->grammar->drop_column($table . '_staging', $column);
    }

    protected function create_file_record_table($table) {
        $column_strings = [
            $this->grammar->column_definition('file_id', 'int(11) unsigned'),
            $this->grammar->column_definition('record_hash', 'varchar(32)'),
            $this->grammar->column_definition('sequence', 'int(11) unsigned'),
        ];
        $index_strings = [
            $this->grammar->index_definition('PRIMARY KEY', '', ['file_id', 'record_hash', 'sequence']),
        ];
        $this->sql[] = $this->grammar->create_table($table . '_file_record', $column_strings, $index_strings);
    }

    protected function create_files_table($table) {
        $column_strings = [
            $this->grammar->column_definition('id', 'int(11) unsigned auto_increment'),
            $this->grammar->column_definition('file_name', 'varchar(128)'),
            $this->grammar->column_definition('last_modified', 'datetime'),
        ];
        $index_strings = [
            $this->grammar->index_definition('PRIMARY KEY', '', ['id']),
            $this->grammar->index_definition('UNIQUE KEY', 'unique_key', ['file_name', 'last_modified']),
        ];
        $this->sql[] = $this->grammar->create_table($table . '_files', $column_strings, $index_strings);
    }

    protected function create_records_table($table, $info) {
        $column_strings = [
            $this->grammar->column_definition('record_hash', 'varchar(32)'),
        ];
        $index_strings = [
            $this->grammar->index_definition('PRIMARY KEY', '', ['record_hash']),
        ];
        foreach ($info['fields'] as $field) {
            $key = $field['name'];
            $field = $this->filter_column($key, $field);
            if ($field === false) continue;
            $column_strings[] = $this->grammar->column_definition($key, $field['type'], isset($field['nullable']) ? $field['nullable'] : false, isset($field['default']) ? $field['default'] : false);
        }
        $index_strings[] = $this->grammar->index_definition('KEY', 'unique_key', $info['key']);
        $this->sql[] = $this->grammar->create_table($table . '_records', $column_strings, $index_strings);
    }

    protected function create_snapshots_table($table) {
        $column_strings = [
            $this->grammar->column_definition('last_modified', 'datetime'),
            $this->grammar->column_definition('file_id', 'int(11) unsigned'),
        ];
        $index_strings = [
            $this->grammar->index_definition('UNIQUE KEY', 'unique_key', ['last_modified', 'file_id']),
        ];
        $this->sql[] = $this->grammar->create_table($table . '_snapshots', $column_strings, $index_strings);
    }

    protected function create_staging_table($table, $info) {
        $column_strings = [
            $this->grammar->column_definition('last_modified', 'datetime'),
            $this->grammar->column_definition('record_hash', 'varchar(32)'),
            $this->grammar->column_definition('sequence', 'int(11) unsigned'),
            $this->grammar->column_definition('file_name', 'varchar(128)'),
        ];
        $index_strings = [
            $this->grammar->index_definition('PRIMARY KEY', '', ['record_hash']),
        ];
        foreach ($info['fields'] as $field) {
            $key = $field['name'];
            $field = $this->filter_column($key, $field);
            if ($field === false) continue;
            $column_strings[] = $this->grammar->column_definition($key, $field['type'], isset($field['nullable']) ? $field['nullable'] : false, isset($field['default']) ? $field['default'] : false);
        }
        $this->sql[] = $this->grammar->create_table($table . '_staging', $column_strings, $index_strings);
    }

    protected function create_latest_view($table) {
        $this->sql[] = <<<SQL
CREATE VIEW `{$table}_latest` AS
SELECT r.*, `f`.`last_modified` AS `import_file_last_modified`
FROM {$table}_records r
JOIN {$table}_file_record j ON (j.record_hash = r.record_hash)
JOIN {$table}_files f ON (j.file_id = f.id)
JOIN {$table}_snapshots sn ON (f.id = sn.file_id)
WHERE sn.last_modified IN ( SELECT max(last_modified) FROM {$table}_snapshots);
SQL;
    }

    protected function filter_column($column, $info) {
        if (array_key_exists('foreign', $info)) return false;
        if (strcasecmp(substr($info['type'], 0, 7), 'varchar')) $info['type'] = 'varchar(32)';
        return $info;
    }
}