<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:29 PM
 */

namespace Visionware\DataManager\Grammars;

class MysqlGrammar implements GrammarInterface {
    public function create_schema($name) {
        return "CREATE DATABASE IF NOT EXISTS `$name`;";
    }

    public function drop_schema($name) {
        return "DROP DATABASE IF EXISTS `$name`;";
    }

    public function use_schema($name) {
        return "USE $name;";
    }

    public function uuid_to_bin() {
        return <<<SQL
CREATE FUNCTION UuidToBin(_uuid BINARY(36))
  RETURNS BINARY(16)
  LANGUAGE SQL
  DETERMINISTIC
  CONTAINS SQL
  SQL SECURITY INVOKER
  RETURN UNHEX(
    CONCAT(
      SUBSTR(_uuid, 15, 4),
      SUBSTR(_uuid, 10, 4),
      SUBSTR(_uuid,  1, 8),
      SUBSTR(_uuid, 20, 4),
      SUBSTR(_uuid, 25)
    )
  );
SQL;

    }

    public function uuid_from_bin() {
        return <<<SQL
CREATE FUNCTION UuidFromBin(_bin BINARY(16))
  RETURNS CHAR(36)
  LANGUAGE SQL
  DETERMINISTIC
  CONTAINS SQL
  SQL SECURITY INVOKER
  RETURN LCASE(
    CONCAT_WS(
      '-',
      HEX(SUBSTR(_bin,  5, 4)),
      HEX(SUBSTR(_bin,  3, 2)),
      HEX(SUBSTR(_bin,  1, 2)),
      HEX(SUBSTR(_bin,  9, 2)),
      HEX(SUBSTR(_bin, 11))
    )
  );
SQL;

    }

    public function create_table($table, $columns, $indices) {
        $columns_string = implode(",\n  ", array_merge($columns, $indices));
        return <<<SQL
CREATE TABLE `$table` (
  $columns_string
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQL;
    }

    public function drop_table($table) {
        return "DROP TABLE IF EXISTS `$table`;";
    }

    public function replace($table, $columns, $values) {
        if (!is_array($columns)) $columns = [$columns];
        $columns_string = ' (`' . implode('`, `', $columns) . '`)';
        if (!is_array($values)) $values = [$values];
        $values_string = ' (' . implode(', ', $values) . ')';
        return "REPLACE INTO `$table` $columns_string VALUES $values_string;";

    }

    public function column_definition($name, $type, $nullable = false, $default = '', $extra = '') {
        $null_string = $nullable ? "" : " NOT NULL";
        $default_string = strlen($default) ? " DEFAULT $default" : '';
        $extra_string = strlen($extra) ? " $extra" : '';
        return "`$name` " . $type . $null_string . $default_string . $extra_string;
    }

    public function uuid_column_definition($name) {
        return $this->column_definition('id', 'binary(16)');
    }

    public function index_definition($index_type, $name, $columns) {
        if (!is_array($columns)) $columns = [$columns];
        $name_string = strlen($name) ? " `$name`" : '';
        $columns_string = ' (`' . implode('`, `', $columns) . '`)';
        return $index_type . $name_string . $columns_string;
    }

    public function create_column($table, $column_string) {
        return "ALTER TABLE `$table` ADD COLUMN $column_string";
    }

    public function drop_column($table, $column_name) {
        return "ALTER TABLE `$table` DROP COLUMN $column_name";
    }
}