<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/9/16
 * Time: 12:33 PM
 */

namespace Visionware\DataManager;

use Exception;

class DefinitionValidator {
    static private $require_keys = [
        'definition' => [
            'tables',
//            'live',
        ],
        'table' => [
            'fields'
        ],
        'field' => [
            'name',
            'type',
        ],
        'join_on' => [
            'local',
            'foreign',
        ]
    ];
//    static private $require_fields = [
//        'columns' => [
//            'name',
//            'column_type',
//            'type',
//            'null',
//            'default',
//            'extra',
//        ],
//        'indices' => [
//            'name',
//            'index_type',
//            'unique',
//            'columns',
//        ],
//        'index_columns' => [
//            'name',
//            'sequence'
//        ],
//        'import_join_columns' => [
//            'local',
//            'foreign',
//            'sequence'
//        ],
//        'tables' => [
//            'name',
//            'columns',
//            'indices',
//            'table_type',
//        ]
//    ];

    private $errors;
    private $definition;

    static private function dot($items) { return implode('.', $items);}
    private function error($path_array, $msg) { $this->errors[] = self::dot($path_array) . " - $msg";}

//    static private function validate_self(&$errors, $object, $key, $type, $path_array) {
//        foreach (self::$require_fields[$type] as $field) {
//            if (!array_key_exists($field, $object)) $errors[] = self::error($path_array, "Object has no '$field' field defined");
//        }
//        if (array_key_exists('name', $object) && $key != $object['name']) $errors[] = self::error($path_array, "Object key does not match defined name field");
//    }
//
//    static public function validate_column(&$errors, $definition, $table_key, $column_key) {
//        $table = $definition['tables'][$table_key];
//        $column = $table['columns'][$column_key];
//        $indexed_columns = [];
//        foreach ($table['indices'] as $index_key => $index) {
//            foreach ($index['columns'] as $index_column_key => $index_column) {
//                $indexed_columns[$index_column['name']] = true;
//            }
//        }
//        $path_array = ['tables', $table_key, 'columns', $column_key];
//        self::validate_self($errors, $column, $column_key, 'columns', $path_array);
//
//        if (array_key_exists('import_field', $column) && !array_key_exists('import_file', $table)) $errors[] = self::error($path_array, "No import_file defined for table");
//
////        if ((substr($column['name'], -3) == '_id') || $column['name'] == 'id') {
////            if ($column['type'] != 'binary(16)') $errors[] = self::error($path_array, "ID column is not type binary(16)");
////
////            $is_in_indices = false;
////            foreach ($table['indices'] as $indexKey=>$index) {
////                foreach ($index['columns'] as $iColumnKey=>$iColumn) {
////                    if ($iColumn['name'] == $column['name']) {
////                        $is_in_indices = true;
////                        break 2;
////                    }
////                }
////            }
////            if (!$is_in_indices) $errors[] = self::error($path_array, "ID column is not defined as an index");
////        }
//        switch ($column['column_type']) {
//            case 'primary':
//                if (!array_key_exists($column['name'], $indexed_columns)) $error[] = self::error($path_array, "Column is not defined as an index");
//                if ($column['type'] != 'binary(16)') $errors[] = self::error($path_array, "ID column is not type binary(16)");
//                break;
//            case 'foreign_key':
//            case 'foreign_id':
//                if (!array_key_exists('references_column', $column)) $errors[] = self::error($path_array, "Foreign column is missing references_column definition");
//                if (!array_key_exists('references_on', $column)) $errors[] = self::error($path_array, "Foreign table is missing references_on definition");
//                if (!@array_key_exists($column['references_on'], $definition['tables'])) $errors[] = self::error($path_array, "Foreign table is missing");
//                if (!@array_key_exists($column['references_column'], $definition['tables'][$column['references_on']]['columns'])) $errors[] = self::error($path_array, "Foreign table is missing foreign column definition");
//                break;
//            case 'column':
//            case 'timestamp':
//            case 'deleted_flag':
//                break;
//            default:
//                $errors[] = self::error($path_array, "Unknown column_type");
//        }
//    }
//
//    static public function validate_index(&$errors, $definition, $table_key, $index_key) {
//        $table = $definition['tables'][$table_key];
//        $index = $table['indices'][$index_key];
//        $path_array = ['tables', $table_key, 'indices', $index_key];
//        self::validate_self($errors, $index, $index_key, 'indices', $path_array);
//        foreach ($index['columns'] as $index_column_key => $index_column) self::validate_index_column($errors, $definition, $table_key, $index_key, $index_column_key);
//        if (array_key_exists('import_join_columns', $index)) {
//            if (!array_key_exists('foreign_table', $index)) $errors[] = self::error($path_array, "Index is missing foreign_table definition");
//            foreach ($index['import_join_columns'] as $import_join_column_key => $import_join_column) self::validate_import_join_column($errors, $definition, $table_key, $index_key, $import_join_column_key);
//        }
//        switch ($index['index_type']) {
//            case 'primary';
//            case 'unique_key':
//                if ($index['unique'] !== true) $errors[] = self::error($path_array, "Index is required to be unique");
//                break;
//            case 'index':
//            case 'foreign_key':
//                break;
//            default:
//                $errors[] = self::error($path_array, "Unknown index_type");
//        }
//    }
//
//    static public function validate_index_column(&$errors, $definition, $table_key, $index_key, $index_column_key) {
//        $table = $definition['tables'][$table_key];
//        $index = $table['indices'][$index_key];
//        $index_column = $index['columns'][$index_column_key];
//        $path_array = ['tables', $table_key, 'indices', $index_key, 'columns', $index_column_key];
//        self::validate_self($errors, $index_column, $index_column_key, 'index_columns', $path_array);
//        if (array_key_exists('foreign_table', $index) && !array_key_exists('foreign_column', $index_column)) $errors[] = self::error($path_array, "Index column is missing foreign_column definition");
//        if (array_key_exists('foreign_column', $index_column) && !array_key_exists('foreign_table', $index)) $errors[] = self::error($path_array, "Index is missing foreign_table definition");
//        if (!array_key_exists($index_column['name'], $table['columns'])) $errors[] = self::error($path_array, "Index column is not defined as a table column");
//        if ($index['index_type'] == 'unique_key' && $table['table_type'] == 'imported' && $table['columns'][$index_column['name']]['column_type'] == 'foreign_id') $errors[] = self::error($path_array, "unique_key cannot contain id columns");
//        if ($index['index_type'] == 'foreign_key' && count($index['columns']) > 1) $errors[] = self::error($path_array, "foreign_key index type cannot have more than one column");
//        if ($table['table_type'] == 'imported' && $index['index_type'] == 'foreign_key' && !array_key_exists('import_join_columns', $index)) $errors[] = self::error($path_array, "foreign_key index type must have import_join_columns");
//
//    }
//
//    static public function validate_import_join_column(&$errors, $definition, $table_key, $index_key, $import_join_column_key) {
//        $table = $definition['tables'][$table_key];
//        $index = $table['indices'][$index_key];
//        $import_join_column = $index['import_join_columns'][$import_join_column_key];
//        $path_array = ['tables', $table_key, 'indices', $index_key, 'import_join_columns', $import_join_column_key];
//        self::validate_self($errors, $import_join_column, $import_join_column_key, 'import_join_columns', $path_array);
//        if (!array_key_exists($import_join_column['local'], $table['columns'])) $errors[] = self::error($path_array, 'Local column is not defined in table');
//        if (!array_key_exists($import_join_column['foreign'], $definition['tables'][$index['foreign_table']]['columns'])) $errors[] = self::error($path_array, 'Foreign column is not defined in foreign table');
//    }
//
////    static public function validate_table(&$errors, $definition, $table_key) {
////        $table = $definition['tables'][$table_key];
////        $path_array = ['tables', $table_key];
////        self::validate_self($errors, $table, $table_key, 'tables', $path_array);
////
////        if (array_key_exists('import_file', $table) && !array_key_exists('unique_key', $table['indices'])) $errors[] = self::error($path_array, "Table has import_file but no unique_key index");
////        foreach ($table['columns'] as $column_key => $column) self::validate_column($errors, $definition, $table_key, $column_key);
////        foreach ($table['indices'] as $index_key => $index) self::validate_index($errors, $definition, $table_key, $index_key);
////
////        if ($table['table_type'] == "imported") {
////            if (!array_key_exists('import_file', $table)) $errors[] = self::error($path_array, "Table is marked as imported type but has no import_file definition");
////        } else if ($table['table_type'] == 'internal') {
////        } else if ($table['table_type'] == 'jobson') {
////        } else if ($table['table_type'] == 'summary') {
////        } else if ($table['table_type'] == 'derived') {
////        } else {
////            $errors[] = self::error($path_array, "Unknown table_type");
////        }
////    }
//
//    static public function validate_import(&$errors, $definition, $import_key) {
//        $path_array = ['import_order', $import_key];
//        if (!array_key_exists($import_key, $definition['tables'])) $errors[] = self::error($path_array, "Table is not defined");
//        if (!array_key_exists('import_file', $definition['tables'][$import_key])) $errors[] = self::error($path_array, "Table has no import_file defined");
//    }

    public function validate($definition) {
        $this->errors = [];
        $this->definition = $definition;
        try {
            $this->check_keys(['definition'], $this->definition, 'definition');
//            foreach ($this->definition['files'] as $key => $file) $this->validate_file($key, $file);
            foreach ($this->definition['tables'] as $key => $table) $this->validate_table($key, $table);
//            foreach ($definition['import_order'] as $import_key) self::validate_import($errors, $definition, $import_key);
//            foreach ($definition['tables'] as $table_key => $table) self::validate_table($errors, $definition, $table_key);
        } catch (Exception $e) {
            $this->errors[] = "EXCEPTION CAUGHT: " . $e->getMessage() . " in file " . $e->getFile() . " at line " .  $e->getLine();
        }
        if (count($this->errors) > 0) array_unshift($this->errors, 'DEFINITION VALIDATION FAILED!');

        return $this->errors;
    }

//    public function validate_file($key, $file) {
//        $path = ['files', $key];
//        $this->check_keys($path, $file, 'file');
//        foreach ($file['fields'] as $field) {
//            $this->check_keys(['files', $key, 'field'], $field, 'file_field');
//        }
//        foreach ($file['key'] as $file_key) {
//            foreach ($file['fields'] as $field) {
//                if ($field['name'] == $file_key) continue 2;
//            }
//            $this->error($path, "Cannot locate key field $file_key in file");
//        }
//    }

    public function validate_table($key, $table) {
        $path = [$key];
        $this->check_keys($path, $table, 'table');
        $imported_froms = [];
        foreach ($table['fields'] as $field) {
            $this->validate_field($key, $field['name'], $field);
            if (array_key_exists('imported_from', $field)) $imported_froms[$field['imported_from']] = true;
        }
//        if ($table['scope'] == 'erpfeed') {
//            if (count($imported_froms) > 1) {
//                $this->error($path, "Table in scope erpfeed cannot import from more than one table");
//            }
//        }
        if (array_key_exists('key', $table)) {
            foreach ($table['key'] as $key_field) {
                if (!$this->lookup($key_field, 'name', $this->definition['tables'][$key]['fields'])) $this->error($path, "Cannot locate key field $key_field in table definition");
            }
        }
    }

    public function validate_field($table_key, $key, $field) {
        $path = [$table_key, $key];
        $this->check_keys($path, $field, 'field');
        if (array_key_exists('nullable', $field) && $field['nullable'] === false) {
            if (array_key_exists('default', $field) && $field['default'] === 'null') $this->error($path, "Field has nullable false and default null");
        }
        $is_imported = array_key_exists('imported_from', $field);
        $is_foreign = array_key_exists('foreign', $field);
        if ($is_imported && $is_foreign) $this->error($path, "Field has both imported_from and foreign keys");
        if ($is_imported) {
            if (!array_key_exists($field['imported_from'], $this->definition['tables'])) $this->error($path, "Cannot locate $field[imported_from] in list of tables");
            else if (!$this->lookup($key, 'name', $this->definition['tables'][$field['imported_from']]['fields'])) $this->error($path, "Cannot locate field $key in table for $field[imported_from]");
        }
        if ($is_foreign) {
            if (!array_key_exists('on_table', $field)) $this->error($path, "Foreign table not defined, on_table key required");
//            if (!array_key_exists('join_on', $field) && !array_key_exists('using', $field)) $this->error($path, "Foreign table join not defined, join_on or using key required");
            if (!array_key_exists($field['on_table'], $this->definition['tables'])) $this->error($path, "Cannot locate foreign table $field[on_table]");
            else {
                if (array_key_exists('join_on', $field)) {
                    foreach ($field['join_on'] as $join_on) {
                        $this->check_keys(array_merge($path, ['join_on']), $join_on, 'join_on');
                        if (!$this->lookup($join_on['local'], 'name', $this->definition['tables'][$table_key]['fields'])) $this->error($path, "Local 'join_on' column $join_on[local] not defined");
                        if (!$this->lookup($join_on['foreign'], 'name', $this->definition['tables'][$field['on_table']]['fields'])) $this->error($path, "Foreign 'join_on' column $join_on[foreign] not defined");
                    }
                } else if (array_key_exists('using', $field)) {
                    // must find all columns joined to this table
                    $joined_fields = [];
                    foreach ($this->definition['tables'][$table_key]['fields'] as $table_field) {
                        if (array_key_exists('imported_from', $table_field)) {
                            $imported_from_table = $this->definition['tables'][$table_field['imported_from']];
                            foreach ($imported_from_table['fields'] as $i_field) $joined_fields[$i_field['name']] = $i_field['name'];
                        }
                        if (array_key_exists('on_table', $table_field)) {
                            $on_table_table = $this->definition['tables'][$table_field['on_table']];
                            foreach ($on_table_table['fields'] as $i_field) $joined_fields[$i_field['name']] = $i_field['name'];
                        }
                    }
                    if (!in_array($field['using'], $joined_fields)) $this->error($path, "Cannot locate $field[using] field in joined tables");
                }
            }
            if ($field['foreign'] !== 'id' && !array_key_exists($field['foreign'], $this->definition['tables'][$field['on_table']])) $this->error($path, "Foreign column $field[foreign] not defined on table $field[on_table]");
        }
    }

    private function lookup($value, $key, $array) {
        foreach ($array as $item) {
            foreach ($item as $k => $v) {
//                dd([func_get_args(), $k, $v]);
                if ($k == $key && $v == $value) return true;
            }
        }
        return false;
    }

    public function check_keys($path, $array, $keys) {
        foreach (self::$require_keys[$keys] as $required) {
            if (!array_key_exists($required, $array)) $this->error($path, "Missing key $required");
        }
    }
}