<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 11:37 AM
 */

namespace Visionware\DataManager\Info;

use Elasticsearch\Endpoints\Index;
use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

class HistorySchemaInfo extends SchemaInfo {
    protected function initActions(ActionManager $actions) {
        $actions->table()->skipTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            return !$tableDefinition->isImported();
        });

        $actions->schema()->appendTable(function (SchemaDefinition $schemaDefinition, SchemaInfo $schemaInfo) {
            $infoTable = TableInfo::create('ingestions');
            $infoTable->putColumn(ColumnInfo::create('table_name', 'varchar(64)'));
            $infoTable->putColumn(ColumnInfo::create('start_time', 'datetime'));
            $infoTable->putColumn(ColumnInfo::create('end_time', 'datetime', true));
            $infoTable->putColumn(ColumnInfo::create('total_time', 'int(11)', true, '-1'));
            $infoTable->putColumn(ColumnInfo::create('state', 'varchar(64)', true));
            $infoTable->putIndex(IndexInfo::create('PRIMARY KEY', ['table_name']));
            return $infoTable;
        });

        $actions->table()->replaceTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            if (!$tableDefinition->isInHistory()) return $tableInfo;
            
            $tables = new Collection;
            $originalName = $tableInfo->name();
            
            $filesTable = TableInfo::create($originalName . "_files");
            $filesTable->putColumn(ColumnInfo::create('id', 'int(11) unsigned', false, '', 'auto_increment'));
            $filesTable->putColumn(ColumnInfo::create('file_name', 'varchar(128)'));
            $filesTable->putColumn(ColumnInfo::create('version_id', 'varchar(128)'));
            $filesTable->putColumn(ColumnInfo::create('modified_time', 'datetime'));
            $filesTable->putIndex(IndexInfo::create('PRIMARY KEY', ['id']));
            $filesTable->putIndex(IndexInfo::create('UNIQUE KEY', ['file_name', 'modified_time'], 'unique_key'));
            $tables->push($filesTable);
            
            $recordsTable = $tableInfo->clone();
            $recordsTable->setName($originalName . "_records");
            $this->filterRecordsColumns($tableDefinition, $recordsTable);
            $recordsTable->prependColumn(ColumnInfo::create('record_hash', 'char(32)'));
            $recordsTable->putColumn(ColumnInfo::create('first_modified_time', 'datetime'));
            $recordsTable->putColumn(ColumnInfo::create('latest_modified_time', 'datetime'));
            $indices = new Collection;
            $indices->push(IndexInfo::create('PRIMARY KEY', ['record_hash']));
            $indices->push(IndexInfo::create('KEY', $tableDefinition->key(), 'unique_key'));
            $indices->push(IndexInfo::create('KEY', array_merge(['first_modified_time'], $tableDefinition->key()), 'first_modified_key'));
            $indices->push(IndexInfo::create('KEY', ['first_modified_time','latest_modified_time'], 'first_latest_modified_key'));
            $indices->push(IndexInfo::create('KEY', ['latest_modified_time'], 'latest_modified_key'));
            $recordsTable->setIndices($indices);
            $tables->push($recordsTable);

//            $tables->push($this->buildLatestTable($tableDefinition, $tableInfo));

//            $latestTable = $tableInfo->clone();
//            $latestTable->setName($originalName . "_latest");
//            $this->filterParentColumns($tableDefinition, $latestTable, true);
//            $latestTable->prependColumn(ColumnInfo::create('record_hash', 'varchar(32)'));
//            $latestTable->putColumn(ColumnInfo::create('date_modified', 'datetime'));
//            $indices = new Collection;
//            $indices->push(IndexInfo::create('PRIMARY KEY', ['record_hash']));
//            $indices->push(IndexInfo::create('KEY', array_merge($tableDefinition->key(), ['date_modified']), 'unique_key'));
//            $latestTable->setIndices($indices);
//            $tables->push($latestTable);

//            $snapshotsTable = TableInfo::create($originalName . "_snapshots");
//            $snapshotsTable->putColumn(ColumnInfo::create('last_modified', 'datetime'));
//            $snapshotsTable->putColumn(ColumnInfo::create('file_id', 'int(11) unsigned'));
//            $snapshotsTable->putIndex(IndexInfo::create('PRIMARY KEY', ['last_modified', 'file_id']));
//            $tables->push($snapshotsTable);

            $stagingTable = $tableInfo->clone();
            $stagingTable->setName($originalName . "_staging");
            $this->filterStagingColumns($tableDefinition, $stagingTable);
            $stagingTable->prependColumn(ColumnInfo::create('file_name', 'varchar(128)'));
            $stagingTable->prependColumn(ColumnInfo::create('file_version_id', 'varchar(128)'));
            $stagingTable->prependColumn(ColumnInfo::create('sequence', 'int(11) unsigned'));
            $stagingTable->prependColumn(ColumnInfo::create('record_hash', 'char(32)'));
            $stagingTable->prependColumn(ColumnInfo::create('file_modified_time', 'datetime'));
            $indices = new Collection;
            $indices->push(IndexInfo::create('PRIMARY KEY', ['record_hash']));
            $stagingTable->setIndices($indices);
            $tables->push($stagingTable);
            return $tables;
        });

//        $actions->table()->viewFromTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
//            if (!$tableDefinition->isImported()) return;
//            $temp = $tableInfo->clone();
//            $tableName = $temp->name();
//
//            $temp->setName($tableName . '_records');
//            $this->filterStagingColumns($tableDefinition, $temp);
//            $temp->prependColumn(ColumnInfo::create('record_hash', 'char(32)'));
////            $temp->putColumn(ColumnInfo::create('latest_modified_time', 'datetime'));
//
//            $columnStrings = [];
//            foreach ($temp->columns() as $column) $columnStrings[] = "`{$temp->name()}`.`{$column->name()}` as `{$column->name()}`";
//            $columnString = implode(',', $columnStrings);
//            $sql = <<<SQL
//SELECT $columnString, `{$tableName}_records`.`latest_modified_time` as `date_modified`
//FROM {$tableName}_records
//JOIN {$tableName}_file_record ON ({$tableName}_file_record.record_hash = {$tableName}_records.record_hash)
//WHERE {$tableName}_file_record.file_id IN (
//  SELECT id FROM (
//    SELECT id, MAX(modified_time) FROM {$tableName}_files GROUP BY file_name
//  ) latestFiles
//)
//SQL;
//
//            return ViewInfo::create($tableName . '_latest', $sql);
//        });

        return $actions;
    }

    protected function filterStagingColumns(TableDefinition $tableDefinition, TableInfo $tableInfo) {
        foreach ($tableInfo->columns() as $column) {
            $fieldDefinition = $tableDefinition->fields()->get($column->name());
            if (is_null($fieldDefinition)) continue;
            if (!$fieldDefinition->shouldImport()) $tableInfo->deleteColumn($column);
            else {
                if ($column->type() != 'text' && !starts_with($column->type(), 'varchar')) {
                    $column->setType('varchar(128)');
                }
            }
        }
    }

    private function filterRecordsColumns(TableDefinition $tableDefinition, TableInfo $tableInfo) {
        foreach ($tableInfo->columns() as $column) {
            $fieldDefinition = $tableDefinition->fields()->get($column->name());
            if (is_null($fieldDefinition)) continue;
            if (!$fieldDefinition->shouldImport()) $tableInfo->deleteColumn($column);
            else {
                if ($fieldDefinition->hasTransformation()) {
                    $newColumn = $column->clone();
                    if ($newColumn->type() != 'text' && !starts_with($newColumn->type(), 'varchar')) {
                        $newColumn->setType('varchar(128)');
                    }
                    $newColumn->setName($fieldDefinition->getUntransformedName());
                    $tableInfo->putColumn($newColumn);
                }
            }
        }
    }
    
    protected function buildLatestTable(TableDefinition $tableDefinition, TableInfo $tableInfo) {
        if (!$tableDefinition->isInHistory()) return $tableInfo;

        $originalName = $tableInfo->name();
        $latestTable = $tableInfo->clone();
        $latestTable->setName($originalName . "_latest");
//        $this->filterStagingColumns($tableDefinition, $latestTable);
        $latestTable->prependColumn(ColumnInfo::create('record_hash', 'char(32)'));
        $latestTable->putColumn(ColumnInfo::create('date_modified', 'datetime'));
        $indices = new Collection;
        $indices->push(IndexInfo::create('PRIMARY KEY', ['record_hash']));
        $indices->push(IndexInfo::create('UNIQUE KEY', array_merge($tableDefinition->key()), 'unique_key'));
        $indices->push(IndexInfo::create('KEY', ['date_modified'], 'date_modified_key'));
        $latestTable->setIndices($indices);

        return $latestTable;
    }
}