<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:47 PM
 */

namespace Visionware\DataManager;

class SqliteSchemaCreator extends SchemaCreator {

    protected function build_columns($table) {
        $columns = [];
        foreach ($table['columns'] as $column) {
            $column = $this->process_column($column);
            if ($column === false) continue;

            $column_string = "`$column[name]` $column[type]";

            if ($column['name'] == 'id') $column_string .= ' PRIMARY KEY';
            else if (!$column['null']) $column_string .= ' NOT NULL';
            else if (!is_null($column['default'])) $column_string .= " DEFAULT $column[default]";
            else if ($column['null']) $column_string .= " DEFAULT NULL";

            $columns[] = $column_string;
        }

        return $columns;
    }

    protected function process_column($column) {
        $column['type'] = preg_replace('/^((?!double)(?!varchar).+?)(\(\d+\))$/','${1}', $column['type']);
        return $column;
    }

    protected function build_indices($table) {
        $indices = [];
        foreach ($table['indices'] as $index) {
            $index = $this->process_index($index);

            if ($index === false) continue;
            $index_string = '"CREATE ';


            if ($index['unique']) $index_string .= 'UNIQUE ';
            $index['name'] = strtolower("$table[name]"."_"."$index[name]");
            uasort(
                $index['columns'],
                function ($a, $b) {
                    return $a['sequence'] - $b['sequence'];
                }
            );
            $columns_string = implode("`, `", array_pluck($index['columns'], 'name'));


            $index_string .= "INDEX `$index[name]` ON $table[name](`$columns_string`)";
            $indices[] = $index_string;
        }

        return $indices;
    }

    protected function process_index($index) {
        if ($index['name'] === 'PRIMARY') return false;
        return $index;
    }

    protected function statement_create($table, $columns_string, $indices_string, $drops) {
        $sql = [];
        if ($drops) $sql[] = "DROP TABLE IF EXISTS `$table`";

        $sql[] = "\"CREATE TABLE `$table` ($columns_string)\",";
        $sql[] = "$indices_string;\",";
        return $sql;
    }

    protected function build_statements($table, $columns, $indices) {
        $columns_string = implode(",  ", $columns);
        $indices_string = implode(";\",\n\n", $indices);

        $statements = [];
        $methods = get_class_methods($this);
        foreach ($methods as $method) {
            if (substr($method, 0, 10) == 'statement_') {
                $statements = array_merge($statements, call_user_func_array([$this, $method], [$table, $columns_string, $indices_string, $this->drops]));
            }
        }
        if (count($statements) == 0) $statements = $this->default_statement_create($table, $columns_string, $indices_string, $this->drops);
        return $statements;
    }
}