<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:47 PM
 */

namespace Visionware\DataManager;
class HistorySchemaCreator extends SchemaCreator {

    protected function process_column($column) {
        if (in_array($column['name'], ['date_created', 'date_modified', 'deleted_at', 'id'])) return false;
        if (substr($column['name'], -3) == '_id') return false;
        if (strcasecmp(substr($column['type'], 0, 7), 'varchar')) $column['type'] = 'varchar(32)';
        return $column;
    }

    protected function process_index($index) {
        return false; // NO INDICES
    }

    protected function process_table($table) {
        if (!isset($table['import_file'])) return false;
        return $table;
    }

    protected function statement_create_records($table, $columns_string, $indices_string, $drops) {
        if ($drops) {
            $sql[] = <<<SQL
DROP TABLE IF EXISTS `{$table}_records`;
SQL;
        }

        $sql[] = <<<SQL
CREATE TABLE `{$table}_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_hash` VARCHAR(32) NOT NULL,
  $columns_string,
  PRIMARY KEY (`id`),
  UNIQUE KEY `record_hash` (`record_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQL;
        return $sql;
    }

    protected function statement_create_files($table, $columns_string, $indices_string, $drops) {
        if ($this->drops) {
            $sql[] = <<<SQL
DROP TABLE IF EXISTS `{$table}_files`;
SQL;
        }
        $sql[] = <<<SQL
CREATE TABLE `{$table}_files` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `last_modified` DATETIME NOT NULL,
  `record_id` VARCHAR(32) NOT NULL,
  `sequence` INT(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_record` (`last_modified`, `sequence`),
  KEY `record` (`record_id`),
  KEY `time` (`last_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQL;
        return $sql;
    }

    protected function statement_create_staging($table, $columns_string, $indices_string, $drops) {
        if ($this->drops) {
            $sql[] = <<<SQL
DROP TABLE IF EXISTS `{$table}_staging`;
SQL;
        }
        $sql[] = <<<SQL
CREATE TABLE `{$table}_staging` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_modified` DATETIME NOT NULL,
  `sequence` INT(11) NOT NULL,
  `record_hash` VARCHAR(32) NOT NULL,
  $columns_string,
  PRIMARY KEY (`id`),
  UNIQUE KEY `record_hash` (`record_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQL;
        return $sql;
    }

    protected function statement_create_latest($table, $columns_string, $indices_string, $drops) {
        if ($this->drops) {
            $sql[] = <<<SQL
DROP VIEW IF EXISTS `{$table}_latest`;
SQL;
        }
        $sql[] = <<<SQL
CREATE VIEW `{$table}_latest` AS
  SELECT r.*
  FROM {$table}_records r
  JOIN {$table}_files f
    ON (f.record_id = r.id)
  WHERE f.last_modified IN (
    SELECT max(last_modified) FROM {$table}_files
);
SQL;
        return $sql;
    }
}