<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use File;
use Illuminate\Console\Command;
use InvalidArgumentException;
use Storage;
use Visionware\DataManager\HistorySchemaCreator;
use Visionware\DataManager\ImportSchemaCreator;
use Visionware\DataManager\ImportStagingSchemaCreator;
use Visionware\DataManager\Providers\DataManagerServiceProvider;
use Visionware\DataManager\SchemaCreator;

class ImportFromCSV extends DataManagerCommand {
    protected $signature = 'datamanager:importcsv {file_or_folder} {output_file}';

    protected $description = 'Builds create statements from one or more CSV files';

    protected function datamanager_handle() {
        $output = $this->argument('output_file');
        $fo = fopen($output, 'w');
        $arg = $this->argument('file_or_folder');
        $files = [];
        if (File::isDirectory($arg)) {
            foreach (File::files($arg) as $file) {
                if (File::extension($file) == 'csv') $files[] = $file;
            }
        } else $files[] = $arg;
        $bom = pack("CCC", 0xef, 0xbb, 0xbf);

        foreach ($files as $file) {
            $pi = pathinfo($file);
            $table = $pi['filename'];
            $ff = fopen($file, 'r');
            $header = fgetcsv($ff);
            fclose($ff);
            $columns = [];
            $column_names = [];
            foreach ($header as $field) {
                $name = str_replace($bom, '', str_replace('"', '', trim($field)));
                $columns[] = "`$name` VARCHAR(255)";
                $column_names[] = $name;
            }

            $sql = "DROP TABLE IF EXISTS `$table`;\n\n";
            fputs($fo, $sql);

            $columns_string = "\n  " . implode(",\n  ", $columns);
            $column_names_string = "\n  " . implode(",\n  ", $column_names);
            $sql = "CREATE TABLE `$table` ($columns_string\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;\n\n";
            fputs($fo, $sql);

            $sql = "LOAD DATA LOCAL INFILE '$file'\nINTO TABLE `$table`\nFIELDS TERMINATED BY ','\nOPTIONALLY ENCLOSED BY '\"'\nIGNORE 1 LINES\n($column_names_string\n);\n\n\n\n";
            fputs($fo, $sql);
        }
        fclose($fo);
    }
}