<?php

namespace Visionware\DataManager\Console\Commands;

use DB;
use Storage;
use Symfony\Component\Console\Output\OutputInterface;

class Import extends DataManagerCommand {
    protected $signature = 'datamanager:import {definition? : The name of the definition in the config file to use for ingestion}';

    protected $description = 'Imports from history database into live database';

    protected function datamanager_handle() {
        foreach ($this->definition['import_order'] as $importName) {
            $this->import($importName);
        }
    }

    private function import($importName) {
        /** 1) Get most recent data from history table and load it into the staging table
         *  2) Populate the staging table with foreign key ID values by using the key fields defined
         *  3) Update the live tables with the filled-in staging table values
         */

    }
}
