<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 11:47 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Config;
use Illuminate\Console\Command;
use InvalidArgumentException;
use Storage;
use Visionware\DataManager\DefinitionValidator;
use Visionware\Utilities\Console\Commands\PrependsDurationTrait;
use Visionware\Utilities\Console\Commands\PrependsOutputTrait;

abstract class DataManagerCommand extends Command {
    use PrependsOutputTrait, PrependsDurationTrait;

    protected $config;
    protected $definition;
    protected $definitionObject;

    public function __construct() {
        parent::__construct();
    }

    public function handle() {
        try {
            $useDefinition = $this->argument('definition');
            if (!strlen($useDefinition)) $useDefinition = Config::get('datamanager.default_definition');
            if (!strlen($useDefinition)) throw new InvalidArgumentException('No definition specified!');
            $this->config = array_dot(Config::get('datamanager.definitions.' . $useDefinition));
            $this->definition = json_decode(Storage::disk($this->config['disk'])->get($this->config['path']), true);
            $errors = DefinitionValidator::validate($this->definition);
            if (count($errors)) {
                foreach ($errors as $msg) $this->error($msg);
                return false;
            }
        } catch (\Symfony\Component\Console\Exception\InvalidArgumentException $e) {

        }

        $this->datamanager_handle();
    }

    /**
     * Overrides the default Command handle method so that we can do the config/definition loading
     * @return mixed
     */
    abstract protected function datamanager_handle();
}