<?php

namespace Visionware\DataManager\Console\Commands;

use DB;
use Storage;
use Visionware\DataManager\HistorySchemaCreator;
use Visionware\DataManager\SqliteSchemaCreator;
use Visionware\DataManager\ImportStagingSchemaCreator;
use Visionware\DataManager\LiveSchemaCreator;

class CreateSchema extends DataManagerCommand {
    protected $signature = 'datamanager:create
            {definition? : The name of the definition in the datamanager.php config file}
            {--output= : Output to file instead of STDOUT}
            {--mode=live : Creation mode history, import, live, sqlite }
            {--execute : Execute the SQL statements instead of printing them to standard out. DESTRUCTIVE!}
            {--drop : Drops tables before creating them}
    ';

    protected $description = 'Builds create statements';

    protected function datamanager_handle() {
        $schema = json_decode(Storage::disk($this->config['disk'])->get($this->config['path']), true );
        if ($this->option('mode') == 'history') $creator = new HistorySchemaCreator($schema, $this->option('drop'));
        else if ($this->option('mode') == 'import') $creator = new ImportStagingSchemaCreator($schema, $this->option('drop'));
        else if ($this->option('mode') == 'live') $creator = new LiveSchemaCreator($schema, $this->option('drop'));
        else if ($this->option('mode') == 'sqllite') $creator = new SqliteSchemaCreator($schema, $this->option('drop'));
        $statements = $creator->build_schema();

        if ($this->option('execute')) {
            foreach ($statements as $statement) {
                DB::connection($this->config['history-database'])->statement($statement);
            }
        } else if ($this->option('output')) file_put_contents($this->option('output'), implode("\n\n", $statements));
        else print implode("\n\n", $statements);
    }
}