<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:29 PM
 */

namespace Visionware\DataManager\Grammars;

class SqliteEmptyGrammar implements GrammarInterface {
    public function create_schema($name) {
        return "";
    }

    public function drop_schema($name) {
        return "";
    }

    public function use_schema($name) {
        return "";
    }

    public function alpha_num() {
        return "";
    }

    public function uuid_to_bin() {
        return "";
    }

    public function uuid_from_bin() {
        return "";
    }

    public function create_table($table, $columns, $indices) {
        $primaryKey = "";
        foreach ($indices as $ii=>$index) {
            if (starts_with($index, "PRIMARY KEY")) {
                $primaryKey = $index;
                unset($indices[$ii]);
                break;
            }
        }

        $columns_string = implode(",\n  ", array_merge($columns, [$primaryKey]));

        $sql = <<<SQL
CREATE TABLE IF NOT EXISTS `$table` (
  $columns_string
);
SQL;

        foreach ($indices as $index) {
//            $sql .= "\n".$index;
        }

        return $sql;
    }

    public function drop_table($table) {
        return "DROP TABLE IF EXISTS `$table`;";
    }

    public function replace($table, $columns, $values) {
        return "";

    }

    public function column_definition($name, $type, $nullable = false, $default = '', $extra = '', $cst_in_version = null) {
        if ($cst_in_version === 'all') {
            $null_string = $nullable ? "" : " NOT NULL";
            $default_string = strlen($default) ? " DEFAULT $default" : ($nullable ? " DEFAULT NULL" : "");

            $sqlite_type = str_replace('unsigned', '', $type);

            return "`$name` $sqlite_type $null_string $default_string";
        } else {
            return null;
        }
    }

    public function uuid_column_definition($name) {
        return $this->column_definition('id', 'binary(16)');
    }

    public function index_definition($table_name, $index_type, $columns, $name)
    {
        $columns_string = ' (`' . implode('`, `', $columns) . '`)';
        if ($index_type == 'PRIMARY KEY') {
            return $index_type . $columns_string;
        } else {
            return "CREATE INDEX IF NOT EXISTS $name ON `$table_name` $columns_string;";
        }
    }

    public function create_column($table, $column_string) {
        return "ALTER TABLE `$table` ADD COLUMN $column_string;";
    }

    public function drop_column($table, $column_name) {
        return "";
    }

    public function create_index($table, $index_string) {
        return "CREATE INDEX $table-index ON `$table` ADD $index_string;";
    }

    public function drop_index($table, $index_name) {
        return "DROP INDEX `$index_name` ON `$table`;";
    }

    public function change_column($table, $column_name, $column_string) {
        return "ALTER TABLE `$table` CHANGE COLUMN `$column_name` $column_string;";
    }
}