<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchema;
use Visionware\DataManager\Schema\Schema;

class IngestTableCommand extends Command {
    protected $signature = 'datamanager:ingest-table {table}
        {--force : Process even if database is up-to-date}
        {--import-after : Used internally by queue workers }
    ';

    protected $description = 'Ingests a single table';

    public function handle() {
        $table_name = $this->argument('table');

        $ingester = DataManager::getIngester();
        $ingester->table_name($table_name)->logger(DataManager::getLogger("ingest-$table_name", $this->getOutput()));
        if ($this->option('force')) $ingester->force(true);
        $ingester->go();
    }
}