<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchema;
use Visionware\DataManager\Schema\Schema;

class ImportCommand extends Command {
    protected $signature = 'datamanager:import 
        {--force : Process even if database is up-to-date}
    ';

    protected $description = 'Imports all tables';

    public function handle() {
        $importer_schema = new ImporterSchema(DataManager::definition());
        $tables_to_import = $importer_schema->tables_to_import();

        $importer = DataManager::getImporter();
        $importer->tables_to_import($tables_to_import)->logger(DataManager::getLogger('importer', $this->getOutput()));
        if ($this->option('force')) $importer->force(true);
        $importer->go();
    }
}