<?php

return [
    'disk' => 'root',
    'path' => 'database/dmschema/',
    'import_source'         => [
        'disk'         => 'hilco-import-s3',
        'prepend_path' => env('DATAMANAGER_IMPORT_PATH_PREFIX', ''),
    ],
    'updater' => [
        'disk' => 'root',
        'path' => 'database/updater',
    ],
    'importer' => [
        'lock_path' => storage_path('importer.lock'),
    ],
    'history-database-connection' => 'hilco-history',
    'historyimport-database-connection' => 'hilco-historyimport',
    'live-database-connection' => 'hilco-live',
    'import-database-connection' => 'hilco-import',
    'history-database-schema' => env('HILCO_DB_HISTORY_DATABASE'),
    'live-database-schema' => env('HILCO_DB_LIVE_DATABASE'),
    'import-database-schema' => env('HILCO_DB_IMPORT_DATABASE'),
    'row_chunk_size' => 10000,
    'import-bucket' => env('AWS_S3_IMPORT_BUCKET'),
    'file_delimiter' => env('FILE_DELIMITER'),
    'slack' => [
        'enabled' => env('SLACK_LOGGING', false),
        'level' => env('SLACK_LOGGING_LEVEL', \Monolog\Logger::NOTICE),
        'token' => env('SLACK_API_TOKEN'),
        'channel' => env('SLACK_CHANNEL'),
        'nick' => env('SLACK_NICK'),
    ],
];