<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:27 PM
 */

namespace Visionware\DataManager\Grammars;

use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\TableInfo;
use Visionware\DataManager\Info\ViewInfo;

abstract class Grammar {

    abstract public function createTable(TableInfo $table);
    abstract public function dropTable(TableInfo $table);
    abstract public function createColumn(ColumnInfo $column);
    abstract public function dropColumn(ColumnInfo $column);
    abstract public function alterColumn(ColumnInfo $column);
    abstract public function createIndex(IndexInfo $index);
    abstract public function dropIndex(IndexInfo $index);
    abstract public function createView(ViewInfo $view);
    abstract public function dropView(ViewInfo $view);
    abstract public function createSchema($name);
    abstract public function dropSchema($name);
    abstract public function useSchema($name);

    protected function compileEach($list, $function, $separator = false) {
        $items = [];
        foreach ($list as $item) {
            $items[] = $this->$function($item);
        }
        return $separator === false ? $items : implode($separator, $items);
    }
}