<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/18/16
 * Time: 12:25 PM
 */

namespace Visionware\DataManager\Schema;

class LiveSchema extends Schema {

    protected function filter_table($table_name, $table) {
        if (array_key_exists('imported_from', $table)) return false;
        foreach ($table['fields'] as $field) if (array_key_exists('imported_from', $field)) return false;
        return true;
    }

    protected function prepend_columns($table_name) {
        return [
            $this->new_column('id', $this->has_uuid($table_name) ? 'binary(16)' : 'int(11) unsigned auto_increment'),
        ];
    }

    protected function prepend_indices($table_name) {
        return [ $this->new_index('PRIMARY KEY', ['id']) ];
    }

    protected function append_columns($table_name) {
        $cols = [];
        if ($this->has_timestamps($table_name)) {
            $cols[] = $this->new_column('date_created', 'datetime', true, 'CURRENT_TIMESTAMP');
            $cols[] = $this->new_column('date_modified','datetime', true,'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP');
        }
        if ($this->has_deleted($table_name)) {
            $cols[] = $this->new_column('deleted_at', 'datetime', true, 'NULL');
        }
        return $cols;
    }
}