<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:27 PM
 */

namespace Visionware\DataManager\Grammars;

interface GrammarInterface {
    public function create_schema($name);
    public function drop_schema($name);
    public function use_schema($name);
    public function uuid_to_bin();
    public function uuid_from_bin();
    public function create_table($table, $columns, $indices);
    public function drop_table($table);
    public function column_definition($name, $type, $nullable = false, $default = '', $extra = '');
    public function uuid_column_definition($name);
    public function index_definition($index_type, $columns, $name);
    public function replace($table, $columns, $values);
    public function create_column($table, $column);
    public function drop_column($table, $column_name);
    public function create_index($table, $index);
    public function drop_index($table, $index);

}