<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 11:37 AM
 */

namespace Visionware\DataManager\Info;

use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

class LiveSchemaInfo extends SchemaInfo {
    protected function initActions(ActionManager $actions) {
        $actions->schema()->appendTable(function (SchemaDefinition $schemaDefinition, SchemaInfo $schemaInfo) {
            $infoTable = TableInfo::create('last_imported');
            $infoTable->putColumn(ColumnInfo::create('table_name', 'varchar(64)'));
            $infoTable->putColumn(ColumnInfo::create('last_imported', 'datetime'));
            $infoTable->putColumn(ColumnInfo::create('import_duration', 'int(11) unsigned', false, 0));
            $infoTable->putIndex(IndexInfo::create('PRIMARY KEY', ['table_name']));
            return $infoTable;
        });

        $actions->table()->prependColumn(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $columns = new Collection;
            if ($tableDefinition->getPrimaryKeyType() !== false) {
                if ($tableDefinition->getOther('pk_type') === 'uuid' && $tableDefinition->isSyncedDown()) {
                    $columns->push(ColumnInfo::create('int_id', 'int(11)', false, '', 'auto_increment'));
                }
                $columns->push(ColumnInfo::createFromDefinition($tableDefinition->getPrimaryKeyField()));
            }
            return $columns;
        });

        $actions->table()->prependIndex(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            if ($tableDefinition->getPrimaryKeyType() !== false) {
                if ($tableDefinition->getOther('pk_type') === 'uuid' && $tableDefinition->isSyncedDown()) {
                    return collect([IndexInfo::create('PRIMARY KEY', ['int_id'], 'PRIMARY'), IndexInfo::create('UNIQUE KEY', ['id'], 'unique_key_id')]);
                } else {
                    return IndexInfo::create('PRIMARY KEY', ['id'], 'PRIMARY');
                }
            }
        });

        $actions->table()->appendIndex(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $indices = new Collection;
            if (count($tableDefinition->key())) {
                $columns = $tableDefinition->key();

                if ($tableDefinition->hasDeleted()) {
                    $columns[] = 'deleted_at';
                }

                $indices->push(IndexInfo::create('UNIQUE KEY', $columns, 'unique_key'));
            }
            if ($tableDefinition->isSyncedDown()) {
                $indices->push(IndexInfo::create('KEY', ['date_uploaded']));
                $indices->push(IndexInfo::create('KEY', ['commit_sequence']));
            }
            foreach ($tableDefinition->fields()->filter(function($item) { return $item->hasForeign(); }) as $field) {
                $indices->push(IndexInfo::create('KEY', [$field->name()], 'fk_' . $field->name()));
            }
            if ($tableDefinition->hasTimestamps()) {
                $indices->push(IndexInfo::create('KEY', ['date_modified']));
            }
            return $indices;
        });

        $actions->table()->appendColumn(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $columns = new Collection;
            if ($tableDefinition->hasTimestamps() || $tableDefinition->isSyncedDown()) {
                $columns->push(ColumnInfo::create('date_created', 'datetime', true, 'CURRENT_TIMESTAMP'));
                $columns->push(ColumnInfo::create('date_modified', 'datetime', true, 'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP'));
            }
            if ($tableDefinition->isSyncedDown()) {
                $columns->push(ColumnInfo::create('date_uploaded', 'datetime', true, 'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP'));
                $columns->push(ColumnInfo::create('commit_sequence', 'bigint(20) unsigned', false, 0));
            }
            if ($tableDefinition->hasDeleted()) {
                $columns->push(ColumnInfo::create('deleted_at', 'datetime', false, '"0000-00-00 00:00:00"'));
            }
            return $columns;
        });

        $actions->table()->siblingTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            if ($tableDefinition->isSyncedUp()) {
                $tempTable = $tableInfo->clone();
                $tempTable->setName("z_" . $tableInfo->name());
                $tempTable->deleteColumn('id');
                $tempTable->deleteColumn('int_id');
                $tempTable->prependColumn(ColumnInfo::create('id', 'binary(16)'));
                $tempTable->prependColumn(ColumnInfo::create('batch_key', 'varchar(32)'));
                $tempTable->prependColumn(ColumnInfo::create('session_key', 'varchar(32)'));
                $tempTable->clearIndices();
                $tempTable->putIndex(IndexInfo::create('PRIMARY KEY', array_merge(['session_key'], ['id'])));
                $tempTable->putIndex(IndexInfo::create('KEY', ['session_key', 'batch_key']));
                return $tempTable;
            }
        });

        $versionList = ['v1'];
        foreach ($versionList as $version) {
            $actions->tableView()->viewFromTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) use ($version) {
                if ($tableDefinition->isSyncedDown()) {
                    $select = [];
                    foreach ($tableInfo->columns() as $column) {
                        $cst_in_version = $column->getOther('cst_in_version', 'all');
                        if ($cst_in_version === 'all' || strpos($cst_in_version, $version) !== false) {
                            $type = $column->qualifiedType();
                            if (starts_with($type, 'binary')) {
                                $select[] = "`UuidFromBin`(`{$tableInfo->name()}`.`{$column->name()}`) AS `{$column->name()}`";
                            } else if (starts_with($type, 'date')) {
                                $select[] = "CASE WHEN `{$tableInfo->name()}`.`{$column->name()}` != 0 THEN `{$tableInfo->name()}`.`{$column->name()}` ELSE NULL END AS `{$column->name()}`";
                            } else {
                                $select[] = "`{$tableInfo->name()}`.`{$column->name()}` AS `{$column->name()}`";
                            }
                        }
                    }
                    $select[] = "`{$tableInfo->name()}`.`id` AS `sort_id`";
                    $selectString = implode(',', $select);

                    return ViewInfo::create("{$tableInfo->name()}_$version", "SELECT $selectString FROM `{$tableInfo->name()}`");
                }
            });
        }

        return $actions;
    }
}