<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:29 PM
 */

namespace Visionware\DataManager\Grammars;

use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\TableInfo;

class SqliteUpgradeGrammar extends SqliteEmptyGrammar
{
    private $version = 0;

    public function createTable(TableInfo $table)
    {
        if ($table->name() == 'Logs' || $table->name() == 'WebLinkCategories') {
            return null;
        }

        $columnStrings = $this->compileEach($table->columns(), 'defineColumn');
        $primaryKey = [];
        $otherIndices = [];
        foreach ($table->indices() as $index) {
            if ($index->isPrimaryKey()) {
                $primaryKey[] = $index;
            } else {
                $otherIndices[] = $index;
            }
        }
        $primaryKeyString = $this->compileEach($primaryKey, 'defineIndex');
        $indexStrings = $this->compileEach($otherIndices, 'defineIndex');
        $strings = implode(",  ", array_merge($columnStrings, $primaryKeyString));

        $indexStringCombined = implode(";\n", $indexStrings) . ";";

        $tableName = $table->name();

        $columnNames = [];
        foreach ($table->columns() as $column) {
            $columnNames[] = $column->name();
        }
        $tableNameString = '`' . implode($columnNames, '`, `') . '`';

        $sql = <<<SQL
case baseVersionNumber + {$this->version}: {
    commandList.add("DROP TABLE IF EXISTS `{$tableName}_temp`;");
    commandList.add("CREATE TABLE `{$tableName}_temp` ($strings);");
    $indexStringCombined
    commandList.add("REPLACE INTO `{$tableName}_temp` ($tableNameString) SELECT $tableNameString FROM `$tableName`;");
    commandList.add("DROP TABLE IF EXISTS `$tableName`;");
    commandList.add("ALTER TABLE `{$tableName}_temp` RENAME TO `{$tableName}`;");
    break;
}
SQL;
        $this->version++;
        return $sql;
    }

    protected function defineIndex(IndexInfo $index)
    {
        if ($index->isPrimaryKey()) {
            $columns_string = ' `' . implode('`, `', $index->columns()) . '`';
            return "PRIMARY KEY ($columns_string)";
        } else {
            $indexName = $index->name();
            $tableName = $index->table()->name();
            $unique = $index->type() != 'KEY' ? $index->type() : '';

            $sql = [];

            $noCaseColumns = $index->noCaseColumns();
            if (count($noCaseColumns) > 0) {
                $columns = $index->columns();

                $columns_string = '`' . implode('`, `', $columns) . '`';
                $sql[] = "DROP INDEX IF EXISTS {$tableName}_{$indexName}";
                $sql[] = "CREATE $unique INDEX IF NOT EXISTS {$tableName}_{$indexName} ON `{$tableName}_temp` ($columns_string)";

                foreach ($columns as $key => $column) {
                    if (in_array($column, $noCaseColumns)) {
                        $columns[$key] = "`$column` COLLATE NOCASE";
                    } else {
                        $columns[$key] = "`$column`";
                    }
                }

                $columns_with_no_case_string = implode(', ', $columns);
                $sql[] = "DROP INDEX IF EXISTS {$tableName}_{$indexName}_no_case";
                $sql[] = "CREATE $unique INDEX IF NOT EXISTS {$tableName}_{$indexName}_no_case ON `{$tableName}_temp` ($columns_with_no_case_string)";
            } else {
                $columns_string = '`' . implode('`, `', $index->columns()) . '`';
                $sql[] = "DROP INDEX IF EXISTS {$tableName}_{$indexName}";
                $sql[] = "CREATE $unique INDEX IF NOT EXISTS {$tableName}_{$indexName} ON `{$tableName}_temp` ($columns_string)";
            }
            return "commandList.add(\"" . implode(";\");\ncommandList.add(\"", $sql) . ";\");";
//            return implode(";\n", $sql);
        }
    }
}