<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/18/16
 * Time: 12:25 PM
 */

namespace Visionware\DataManager\Schema;

class SqliteSchemaInfo extends SchemaInfo {
    protected function prepend_columns($table_name) {
        if ($this->has_uuid($table_name)) {
            return [
                $this->new_column('id', 'binary(16)'),
            ];
        } else {
            return [
                $this->new_column('id', 'int(11) unsigned', false, '', 'auto_increment'),
            ];
        }
    }

    protected function prepend_indices($table_name) {
        return [ $this->new_index('PRIMARY KEY', ['id']) ];
    }

    protected function append_indices($table_name) {
        $indices = [];
        if ($this->is_synced_down($table_name)) {
            $indices[] = $this->new_index('KEY', ['date_uploaded']);
        }
        return $indices;
    }

    protected function append_columns($table_name) {
        $cols = [];
        if ($this->has_timestamps($table_name) || $this->is_synced_down($table_name)) {
            $cols[] = $this->new_column('date_created', 'datetime', true, 'CURRENT_TIMESTAMP');
            $cols[] = $this->new_column('date_modified','datetime', true,'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP');
        }
        if ($this->is_synced_down($table_name)) {
            $cols[] = $this->new_column('date_uploaded','datetime', true,'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP');
        }
        if ($this->has_deleted($table_name)) {
            $cols[] = $this->new_column('deleted_at', 'datetime', true, 'NULL');
        }
        return $cols;
    }
    }