<?php

namespace Visionware\DataManager;

interface HasCustomLogging {
    public function getConsoleFormat();
    public function configureLogging($processName, $outputInterface = null);
    public function prepareLogContext($context);
    public function log($level, $message, $context);
    public function emergency($message, $context = []);
    public function alert($message, $context = []);
    public function critical($message, $context = []);
    public function error($message, $context = []);
    public function warning($message, $context = []);
    public function notice($message, $context = []);
    public function info($message, $context = []);
    public function debug($message, $context = []);
}