<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/25/16
 * Time: 9:04 AM
 */

namespace Visionware\DataManager\Providers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\ServiceProvider;
use Visionware\DataManager\Console\Commands\BucketCommand;
use Visionware\DataManager\Console\Commands\CreateSchemaCommand;
use Visionware\DataManager\Console\Commands\ImportCommand;
use Visionware\DataManager\Console\Commands\InfoCommand;
use Visionware\DataManager\Console\Commands\IngestCommand;
use Visionware\DataManager\Console\Commands\IngestTableCommand;
use Visionware\DataManager\Console\Commands\ScheduleCommand;
use Visionware\DataManager\Console\Commands\SchemaInfoCommand;
use Visionware\DataManager\Console\Commands\SyncTestCommand;
use Visionware\DataManager\Console\Commands\TransfererCommand;

class DataManagerServiceProvider extends ServiceProvider {

    public function register() {
        $this->commands([
            CreateSchemaCommand::class,
            IngestCommand::class,
            IngestTableCommand::class,
            TransfererCommand::class,
            ImportCommand::class,
            SchemaInfoCommand::class,
            InfoCommand::class,
            SyncTestCommand::class,
        ]
        );

        App::singleton('datamanager', function() {
            return new \Visionware\DataManager\DataManagerHelper();
        });
    }

    public function boot() {
        $this->publishes([
            __DIR__ . '/../../config/datamanager.php' => config_path('datamanager.php'),
        ], 'datamanager');
    }
}