<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Illuminate\Database\Connection;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchemaInfo;
use Visionware\DataManager\Schema\SchemaInfo;

class InfoCommand extends Command {
    protected $signature = 'datamanager:info {mode} {action} {table?} ';

    protected $description = 'Infos';

    public function handle() {
        $mode = $this->argument('mode');
        $action = $this->argument('action');
        /** @var Connection $db */
        $db = DataManager::getConnectionForMode($mode);
        $schema = DataManager::getSchemaInfo($mode);
        switch ($action) {
            case 'modified':
                $this->info('Gathering data...');
                $rows = [];
                $tables = $schema->tables();
                $bar = $this->output->createProgressBar(count($tables));
                $bar->setFormat(' %current%/%max% [%bar%] %percent:3s%% %message%');
                $bar->setMessage('');
                $bar->start();
                foreach ($tables as $table) {
                    if (is_null($table->definition()) || !$table->definition()->isSyncedDown()) continue;
                    $bar->setMessage($table->name() . '                         ');
                    $results = $db->select(DB::raw("SELECT date_modified, count(distinct id) as theCount FROM $table GROUP BY date_modified ORDER BY date_modified DESC LIMIT 1"));
                    foreach ($results as $result) {
                        $rows[] = [$table->name(), $result->date_modified, $result->theCount];
                    }
                    $bar->advance();
                }
                $bar->finish();
                $this->table(['Table', 'Date Modified', 'Rows'], $rows);
                break;
            case 'modified-table':
                $this->info('Gathering data...');
                $rows = [];
                $tables = $schema->tables();
                foreach ($tables as $table) {
                    if (is_null($table->definition()) || !$table->definition()->isSyncedDown()) continue;
                    if ($table->name() != $this->argument('table')) continue;
                    $results = $db->select(DB::raw("SELECT date_modified, count(distinct id) as theCount FROM $table GROUP BY date_modified ORDER BY date_modified DESC"));
                    foreach ($results as $result) {
                        $rows[] = [$table->name(), $result->date_modified, $result->theCount];
                    }
                }
                $this->table(['Table', 'Date Modified', 'Rows'], $rows);
                break;
            case 'uploaded':
                $this->info('Gathering data...');
                $rows = [];
                $tables = $schema->tables();
                $bar = $this->output->createProgressBar(count($tables));
                $bar->setFormat(' %current%/%max% [%bar%] %percent:3s%% %message%');
                $bar->setMessage('');
                $bar->start();
                foreach ($tables as $table) {
                    if (is_null($table->definition()) || !$table->definition()->isSyncedDown()) continue;
                    $bar->setMessage($table->name() . '                         ');
                    $results = $db->select(DB::raw("SELECT date_uploaded, count(distinct id) as theCount FROM $table GROUP BY date_uploaded ORDER BY date_uploaded DESC LIMIT 1"));
                    foreach ($results as $result) {
                        $rows[] = [$table->name(), $result->date_uploaded, $result->theCount];
                    }
                    $bar->advance();
                }
                $bar->finish();
                $this->table(['Table', 'Date Uploaded', 'Rows'], $rows);
                break;
            case 'uploaded-table':
                $this->info('Gathering data...');
                $rows = [];
                $tables = $schema->tables();
                foreach ($tables as $table) {
                    if (is_null($table->definition()) || !$table->definition()->isSyncedDown()) continue;
                    if ($table->name() != $this->argument('table')) continue;
                    $results = $db->select(DB::raw("SELECT date_uploaded, count(distinct id) as theCount FROM $table GROUP BY date_uploaded ORDER BY date_uploaded DESC"));
                    foreach ($results as $result) {
                        $rows[] = [$table->name(), $result->date_uploaded, $result->theCount];
                    }
                }
                $this->table(['Table', 'Date Uploaded', 'Rows'], $rows);
                break;            
        }
    }
}