<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Illuminate\Console\Command;
use Visionware\DataManager\Facades\DataManager;

class ImportCommand extends Command {
    protected $signature = 'datamanager:import 
        {--force : Process even if database is up-to-date}
        {--skip-transactions : Don\' do this}
        {--single-table= : Or this}
    ';

    protected $description = 'Imports all tables';

    public function handle() {
        $importer = DataManager::getImporter($this->getOutput());
        if ($this->option('force')) $importer->force(true);
        if ($this->option('skip-transactions')) $importer->noTransactions();
        if ($this->option('single-table')) {
            $importer->noTransactions();
            $importer->only($this->option('single-table'));
        }
        $importer->go();
    }
}