<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/25/16
 * Time: 9:04 AM
 */

namespace Visionware\DataManager\Providers;

use Illuminate\Support\ServiceProvider;
use Visionware\DataManager\Console\Commands\Create;
use Visionware\DataManager\Console\Commands\CreateSchema;
use Visionware\DataManager\Console\Commands\GenerateSchema;
use Visionware\DataManager\Console\Commands\Import;
use Visionware\DataManager\Console\Commands\Ingest;
use Visionware\DataManager\Console\Commands\ImportFromCSV;
use Visionware\DataManager\Console\Commands\ReverseEngineer;
use Visionware\DataManager\Console\Commands\Validate;

class DataManagerServiceProvider extends ServiceProvider {

    public function register() {
        $this->commands([
            ImportFromCSV::class,
            CreateSchema::class,
            ReverseEngineer::class,
            Ingest::class,
            Validate::class,
            Import::class,
        ]);
    }

    public function boot() {
        $this->publishes([
            __DIR__ . '/../../config/datamanager.php' => config_path('datamanager.php'),
        ], 'datamanager');
    }
}