<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use League\Flysystem\Exception;
use Monolog\Logger;
use DataManager;

class IngestCommand extends Command {
    protected $signature = 'datamanager:ingest
        {--force : Process even if database is up-to-date}
        {--skip= : Comma separated list of tables to skip (overrides --only values)}
        {--only= : Comma separated list of tables to import (will skip everything else) }       
        {--queue : Push jobs to the application queue instead of processing now }
        {--all-versions : Gets all past versions  }
        {--skip-transactions : Don\'t do this }
        {--newer-than= : yyyy-mm-dd }
        {--latest-only : Only rebuilds latest records tables }
        {--log-name= : Use an alternate log file name } 
        {--skip-live-check-append-only : Insert Records into latest tables regardless of whether we detect that they are already on live (comparing records first_modified to lives last_modified) }
        {--use-newest-only : Use only the newest version of the file } 
    ';
    protected $description = 'Ingests data';
    private $schema;

    private function process_skip_only($tables) {
        $skip = is_null($this->option('skip')) ? [] : explode(',', $this->option('skip'));
        $only = is_null($this->option('only')) ? [] : explode(',', $this->option('only'));
        $out = [];
        foreach ($tables as $table_name) {
            if (count($only) && !in_array($table_name, $only)) continue;
            if (in_array($table_name, $skip)) continue;
            $out[$table_name] = $table_name;
        }

        return array_values($out);
    }

    public function handle() {
        $this->schema = DataManager::getSchemaInfo();

        foreach ($this->process_skip_only($this->schema->tablesToIngest()->keys()->toArray()) as $table_name) {
            $options = ['table' => $table_name];
            if ($this->option('force')) $options['--force'] = true;
            if ($this->option('all-versions')) $options['--all-versions'] = true;
            if ($this->option('skip-transactions')) $options['--skip-transactions'] = true;
            if ($this->option('newer-than')) $options['--newer-than'] = $this->option('newer-than');
            if ($this->option('latest-only')) $options['--latest-only'] = true;
            if ($this->option('log-name')) $options['--log-name'] = $this->option('log-name');
            if ($this->option('skip-live-check-append-only')) $options['--skip-live-check-append-only'] = true;
            if ($this->option('use-newest-only')) $options['--use-newest-only'] = true;
            $this->call('datamanager:ingest-table', $options);
        }
    }
}