<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 4:37 PM
 */

namespace Visionware\DataManager\Actions;

use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\Definition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\Info;

class Action {
    private $operations;
    protected $allowedOperations = [];

    public function __construct() {
        $this->operations = new Collection;
    }

    protected function pushOperation($operation, $callback) {
        $list = $this->operations->get($operation, false);
        if ($list === false) {
            $list = new Collection;
            $this->operations->put($operation, $list);
        }
        $list->push($callback);
    }

    /**
     * @param $operation
     * @return Collection
     */
    protected function getOperations($operation) {
        return $this->operations->get($operation, []);
    }

    public function __call($name, $arguments) {
        if (in_array($name, $this->allowedOperations)) {
            $this->pushOperation($name, $arguments[0]);
            return;
        }
        else if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        trigger_error("Cannot find method $name in object!");
    }

    public function execute(Definition $definition, Info $info) {
        foreach ($this->allowedOperations as $operation) {
            foreach ($this->getOperations($operation) as $callback) {
                $method = 'execute' . studly_case($operation);
                $result = $callback($definition, $info);
                if ($result instanceof Collection) {
                     foreach ($result as $item) $info = call_user_func_array([$this, $method], [$item, $info]);
                } else if ($result instanceof Info) {
                    $info = call_user_func_array([$this, $method], [$result, $info]);
                }
            }
        }
        return $info;
    }
}