<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 11:37 AM
 */

namespace Visionware\DataManager\Info;

use Illuminate\Database\Connection;
use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\FieldDefinition;

class MySqlSchemaInfo extends SchemaInfo {
    public static function createFromConnection(Connection $connection) {
        $instance = new static();

        $instance->putOther('connection', $connection);
        foreach (MySqlSchemaInfo::mysql_tables($connection) as $table_name) {

        }

    }

    public static function mysql_tables(Connection $connection) {
        
    }

    /**
     * @param Connection $connection
     * @param $table_name
     * @return Collection
     */
    public static function mysqlColumnsToFieldInfo(Connection $connection, $table_name) {
        $fields = new Collection;
        $columns = $connection->select("SHOW COLUMNS FROM $table_name");
        $return = [];
        foreach ($columns as $column) {
            $fieldDefinition = FieldDefinition::hydrate([
                'name' => $column->Field,
                'type' => strtolower($column->Type),
                'nullable' => $column->Null == 'YES',
                'default' => strtoupper((is_null($column->Default) && $column->Null == 'YES') ? 'NULL' : $column->Default),
                'extra' => strtoupper($column->Extra),
            ]);
            $fields->push($fieldDefinition);
        }
        return $return;
    }

}