<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use Exception;
use Storage;
use Visionware\DataManager\Grammars\MysqlGrammar;
use Visionware\DataManager\SchemaManager;

class CreateSchema extends DataManagerCommand {
    protected $datamanager_command_name = 'datamanager:create';
    protected $datamanager_signature = '
            {--output= : Output to a file instead of stdout.}
            {--mode= : Creation mode history, live, sqlite, all (history, live) }
            {--recreate : Includes drop database statements}
    ';

    protected $description = 'Builds create statements';

    protected function datamanager_handle() {
        if ($this->option('mode') == 'sqlite' && is_null($this->option('output'))) {
            $this->error("You must specify an output file when using SQLite mode!");
            return false;
        }

        $modes = $this->option('mode') == 'all' ? ['history', 'live'] : [$this->option('mode')];

//        $history_db_name = Config::get('database.connections.' . $this->config['history-database-connection'] . '.database');
//        $live_db_name = Config::get('database.connections.' . $this->config['live-database-connection'] . '.database');

//        $mode = $this->option('mode');

        $statements = [];
        $log = [];
        foreach ($modes as $mode) {
            $name = Config::get('database.connections.' . $this->config["$mode-database-connection"] . '.database');
            try {
                $connection = DB::connection($this->config["$mode-database-connection"]);
                $current_definition = $connection->table('datamanager_metadata')
                    ->where('metadata_type', '=', 'definition')
                    ->where('metadata_key', '=', 'definition')
                    ->value('longtext_value');
                $current_definition = json_decode($current_definition, true);
            } catch (Exception $e) {
                $current_definition = false;
            }
//            $classname = 'Visionware\\DataManager\\' . ucfirst($mode) . 'SchemaManager';
            $schemaclassname = 'Visionware\\DataManager\\Schema\\' . ucfirst($mode) . 'Schema';
            $schema = new $schemaclassname($this->definition);
            $current_schema = $current_definition ? new $schemaclassname($current_definition) : null;
            $creator = new SchemaManager(new MysqlGrammar(), $name, $schema, $current_schema);
            if ($this->option('recreate')) $creator->setRecreate();
            $statements = array_merge($statements, $creator->migrate($log));
        }

//        if ($this->option('mode') == 'sqlite') {
//            usort($statements, array($this,"sqliteStatementCompare"));
//        }
        if (!count($statements)) {
            $this->info('No changes are necessary.');
        } else {
            if ($this->option('output')) {
                file_put_contents($this->option('output'), implode("\n\n", $statements));
                foreach ($log as $entry) $this->info($entry);
                $this->info('Statements written to file: ' .$this->option('output'));
            } else {
                print implode("\n\n", $statements);
            }
        }
    }

    function sqliteStatementCompare($a, $b) {

        if (strpos($a, "CREATE TABLE") === strpos($b, "CREATE TABLE")) {
            return strcmp($a, $b);
        } else {
            return strpos($a, "CREATE TABLE") < strpos($b, "CREATE TABLE") ? 1 : -1;
        }
    }
}