<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 11:37 AM
 */

namespace Visionware\DataManager\Info;

use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

class SqliteSchemaInfo extends SchemaInfo {
    protected function initActions(ActionManager $actions) {
        $actions->table()->prependColumn(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $columns = new Collection;
            if ($tableDefinition->getPrimaryKeyType() !== false) {
                $columns->push(ColumnInfo::createFromDefinition($tableDefinition->getPrimaryKeyField()));
            }
            return $columns;
        });

        $actions->table()->prependIndex(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            if ($tableDefinition->getPrimaryKeyType() !== false) {
                return IndexInfo::create('PRIMARY KEY', ['id'], 'PRIMARY');
            }
        });

        $actions->table()->appendColumn(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $columns = new Collection;
            if ($tableDefinition->hasTimestamps() || $tableDefinition->isSyncedDown()) {
                $columns->push(ColumnInfo::create('date_created', 'datetime', true, 'CURRENT_TIMESTAMP'));
                $columns->push(ColumnInfo::create('date_modified', 'datetime', true, 'CURRENT_TIMESTAMP', 'ON UPDATE CURRENT_TIMESTAMP'));
            }
            if ($tableDefinition->isSyncedUp()) {
                $columns->push(ColumnInfo::create('is_modified', 'tinyint(1)', false, '0'));
            }
            if ($tableDefinition->hasDeleted()) {
                $columns->push(ColumnInfo::create('deleted_at', 'datetime', true, 'NULL'));
            }
            return $columns;
        });

        $actions->table()->appendIndex(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            $indices = new Collection;
            if (count($tableDefinition->key())) {
                $indices->push(IndexInfo::create('KEY', $tableDefinition->key(), 'unique_key'));
            }
            foreach ($tableDefinition->fields()->filter(function($item) { return $item->hasForeign(); }) as $field) {
                $indices->push(IndexInfo::create('KEY', [$field->name()], 'fk_' . $field->name()));
            }
            return $indices;
        });

        return $actions;
    }
}