<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/13/16
 * Time: 10:16 AM
 */

namespace Visionware\DataManager;

use Exception;
use Illuminate\Support\Collection;
use Monolog\Logger;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Facades\DataManager;
use Carbon\Carbon;
use Illuminate\Database\Connection;

/**
 * Class Updater
 * @package Visionware\DataManager
 * @method emergency(string $msg, array $context = [])
 * @method alert(string $msg, array $context = [])
 * @method critical(string $msg, array $context = [])
 * @method error(string $msg, array $context = [])
 * @method warn(string $msg, array $context = [])
 * @method notice(string $msg, array $context = [])
 * @method info(string $msg, array $context = [])
 */
class Updater extends DataManagerProcess {
    /** @var Connection */
    protected $liveDb;

    public function __construct($schema) {
        parent::__construct($schema);
        $this->liveDb = DataManager::getLiveConnection();
    }

    public function go() {
        $allStart = Carbon::now();

        try {
            $this->info("Acquiring import lock...");
            DataManager::acquireImportLock();

            $files = DataManager::getUpdaterFiles();
            $db = DataManager::getLiveConnection();
            foreach ($files as $file) {
                $arr = explode('_', str_replace('.php', '', basename($file)));
                $className = $arr[1];
                $this->setLogPrefix($className);
                require_once $file;
                $class = new $className($db, $this);
                $this->notice("Executing updater class");
                $db->transaction(function () use ($class) {
                    $class->go();
                });
            }
        } finally {
            $this->info("Releasing import lock...");
            DataManager::releaseImportLock();
        }

        $diff = Carbon::now()->diffForHumans($allStart, true);
        $this->notice("Finished update process in $diff total");
    }
}