<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/13/16
 * Time: 11:09 AM
 */

namespace Visionware\DataManager;

use Monolog\Logger;
use Log;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

abstract class DataManagerProcess {
    protected $tableName;
    /**
     * @var TableInfo
     */
    protected $info;
    /**
     * @var TableDefinition
     */
    protected $definition;
    protected $force;
    public $logger;
    protected $schema;
    protected $logPrefix;

    public function __construct(SchemaInfo $schema) {
        $this->schema = $schema;
        $this->force = false;
        $this->run_after_completed = false;
        $this->logger = Log::getMonolog();
        $this->logPrefix = '';
    }

    abstract public function go();

    public function setTable(string $tableName) {
        $this->info = $this->schema->tables()->get($tableName);
        $this->definition = $this->info->definition();
        $this->tableName = $tableName;
        return $this;
    }

    protected function setLogPrefix($prefix) {
        $this->logPrefix = "($prefix) ";
    }

    public function force($val = false) {
        $this->force = $val;
        return $this;
    }

    public function logger(Logger $logger) {
        $this->logger = $logger;
        return $this;
    }

    function __call($name, $arguments) {
        if (in_array($name, ['emergency', 'alert', 'critical', 'error', 'warn', 'notice', 'info', 'debug'])) {
            if (isset($this->logPrefix) && isset($arguments[0])) $arguments[0] = $this->logPrefix . $arguments[0];
            call_user_func_array([$this->logger, $name], $arguments);

//            $arguments[1] = array_merge(isset($arguments[1]) ? $arguments[1] : [], ['datamanager-table' => $this->tableName]);
            $logger = Log::getMonolog();

            return call_user_func_array([$logger, $name], $arguments);
        } else if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        trigger_error("Call to unhandled __call function $name()", E_USER_ERROR);
    }
}