<?php

namespace Visionware\DataManager\Console\Commands;

use DataManager;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Importer;
use Visionware\DataManager\Info\LiveSchemaInfo;
use Visionware\DataManager\Info\MySqlSchemaInfo;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

class SchemaInfoCommand extends Command {
    protected $signature = 'datamanager:schema      
        {--mode= : Schema class to use }
        {--func= : schema function }
        {args?*}
    ';

    protected $description = 'Schema information';

    public function handle() {
        $schema = DataManager::getSchemaInfo();

        $importer = new Importer;
        $schema = DataManager::getSchemaInfo();

//        $importer->useTransactions(false);
//        $importer->setLogger(DataManager::getLogger('importer', $this->getOutput()));
//        $importer->setTable($schema->tables()->get('Customers')->definition());
//        $importer->import();
//
        dd($schema->tablesToImport()->toArray());


        /** @var TableInfo $table */
        foreach ($schema->tables() as $table) {
            if (!$table->shouldImport()) continue;
            $table->buildDependencies();
            
            $resolved = new Collection;
            $output = new Collection;
            $table->dependencyTree($resolved, $output);
            print implode("\n", $output->toArray());
            print "\n\n";
        };

//        $definition = SchemaDefinition::hydrate(DataManager::definition());
//        $info = LiveSchemaInfo::createFromDefinition($definition);
//        $tables = $info->tables();
//        dd($tables->get('z_RMAs'));
//        $ss = new TestSchemaInfo($definition);
//        dd($ss->tables()->get('SalesOrders'));
//        $schemaclassname = 'Visionware\\DataManager\\Schema\\' . ucfirst($this->option('mode')) . 'Schema';
//        $schema = new $schemaclassname(DataManager::definition());
//        $function = $this->option('func');
//        $arguments = $this->argument('args');
//
//        $response = call_user_func_array([$schema, $function], $arguments);
//        $this->info(json_encode($response, JSON_PRETTY_PRINT));
    }
}
