<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/16/16
 * Time: 2:29 PM
 */

namespace Visionware\DataManager\Grammars;

use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\TableInfo;
use Visionware\DataManager\Info\ViewInfo;

class SqliteEmptyGrammar extends Grammar {

    public function createTable(TableInfo $table) {
        $columnStrings = $this->compileEach($table->columns(), 'defineColumn');
        $primaryKey = [];
        $otherIndices = [];
        foreach ($table->indices() as $index) {
            if ($index->isPrimaryKey()) {
                $primaryKey[] = $index;
            } else {
                $otherIndices[] = $index;
            }
        }
        $primaryKeyString = $this->compileEach($primaryKey, 'defineIndex');
        $indexStrings = $this->compileEach($otherIndices, 'defineIndex');
        $strings = implode(",  ", array_merge($columnStrings, $primaryKeyString));

        $indexStringCombined = implode(";\n", $indexStrings).";";

        $tableName = $table->name();
        return <<<SQL
DROP TABLE IF EXISTS `$tableName`;
CREATE TABLE IF NOT EXISTS `$tableName` ($strings);
$indexStringCombined
SQL;
    }

    protected function defineColumn(ColumnInfo $column)
    {
        $name = '`' . $column->name() . '` ';
        $qualifiedType = $column->qualifiedType();
        $qualifiedType = str_replace('unsigned', '', $qualifiedType);

        $null = '';
        $default = '';
//        if (!starts_with(strtoupper($qualifiedType), 'DATE')) {
//            $null = $column->nullable()  ? "" : " NOT NULL";
//            $default = strlen($column->default()) ? " DEFAULT " . $column->default() : ($column->nullable() ? ' DEFAULT NULL' : '');
//        }

        return implode('', [$name, $qualifiedType, $null, $default]);
    }

    protected function defineIndex(IndexInfo $index) {
        if ($index->isPrimaryKey()) {
            $columns_string = ' `' . implode('`, `', $index->columns()) . '`';
            return "PRIMARY KEY ($columns_string)";
        } else {
            $indexName = $index->name();
            $tableName = $index->table()->name();
            $columns_string = '`' . implode('`, `', $index->columns()) . '`';
            return "CREATE INDEX IF NOT EXISTS {$tableName}_{$indexName} ON $tableName ($columns_string)";
        }
    }

    public function dropTable(TableInfo $table) {
        return null;
    }

    public function createColumn(ColumnInfo $column) {
        return null;
    }

    public function dropColumn(ColumnInfo $column) {
        return null;
    }

    public function createIndex(IndexInfo $index) {
        return null;
    }

    public function dropIndex(IndexInfo $index) {
        return null;
    }

    public function alterColumn(ColumnInfo $column) {
        return null;
    }

    public function createView(ViewInfo $view) {
        return null;
    }

    public function dropView(ViewInfo $view) {
        return null;
    }

    public function createSchema($name) {
        return null;
    }

    public function dropSchema($name) {
        return null;
    }

    public function useSchema($name) {
        return null;
    }

    public function createAlphaNumFunction() {
        return null;
    }

    public function createUuidToBinFunction() {
        return null;
    }

    public function createUuidFromBinFunction() {
        return null;
    }
}