<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 9:37 AM
 */

namespace Visionware\DataManager\Info;

use Closure;
use Visionware\DataManager\Definition\Definition;

class ActionHandler {
    private $target;
    private $callback;

    /**
     * ActionHandler constructor.
     * @param string $target
     * @param bool $when
     * @param Closure $callback
     */
    public function __construct(string $target, Closure $callback) {
        $this->target = $target;
        $this->callback = $callback;
    }

    public function target() {
        return $this->target;
    }

    public function call(Definition $definition, Info $info) {
        return call_user_func_array($this->callback, [$definition, $info]);
    }
    
    
}